;This is a program is part of the Chapter 14 exercises to demonstrate how to use the
;TMR0 resource.  In this program, an LED is tied to PORTC,4 and a speaker is connected 
;to PORTC,5.  The main program will flash the LED at one second intervals.  The TMR0 
;resource is set up to provide an interrupt at 500 uS intervals to send pulse train
;to the speaker to generate a 1000Hz tone.



	list      p=16F676       ; list directive to define processor
	#include <p16f676.inc>    ; processor specific variable definitions



	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _HS_OSC & _MCLRE_OFF & _CPD_OFF
; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80
#define TMR0_scale	.14			;TMR0 preload factor, this value gives 1000Hz toggle
;*******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	count					;used by the delay subroutines
	tempa
	w_temp					;used in interrupt service to store old values of
	status_temp				;w and STATUS registers
	endc

;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	goto interrupt_service
	return			; interrupt trap - returns without re-enabling
;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL	Bank1
	call    0x3FF      ; retrieve factory calibration value
	movwf	OSCCAL

	BANKSEL	Bank0		;select bank0
	clrf	PORTA		;clear port bus
	clrf	PORTC
	movlw	b'00000111'	;comparator disconnected
	movwf	CMCON		;

	BANKSEL	Bank1		; BANK1
	movlw	b'00000000'	;TMR0 set-up:  pull-ups enabled,X,internal clk,X,
						;pre-scale tmr0, pre-scale 1:2 
	movwf	OPTION_REG	;put w reg into option register

	movlw	b'00000000'	;all PORTA I/O outputs
	movwf	TRISA		;program PORTA
	movlw	b'00000000'	;all PORTC I/O outputs
	movwf	TRISC		;program PORTC
	movlw	b'00000000'	;all digital
	movwf	ANSEL		
	BANKSEL	Bank0		;back to bank0
		
	movlw	b'00000000'	;globals disabled, TMR0 disabled, clear T0IF
	movwf	INTCON

;end pic initialization

;*****************************************************************************

;main program
	movlw	TMR0_scale		;preload TMR0 for a count that will generate a
	movwf	TMR0			;1000Hz tone in the speaker.  Value defined above.

	bcf		INTCON,T0IF		;clear TMR0 interrupt flag
	bsf		INTCON,T0IE		;enable TMR0
	bsf		INTCON,GIE		;enable global interrupts
	bsf		PORTC,5			;start with high on output pin on the speaker


self
	movlw	b'00010000'		;the main code flashes the LED on PORTC, 4
	xorwf	PORTC,f			;at 1 second intervals
	call 	wait1sec
	goto	self

interrupt_service
	bcf		INTCON,T0IE		;disable TMR0 interrupt
	bcf		INTCON,T0IF		;clear TMR0 interrupt flag

	movwf	w_temp			;copy contents of w_reg into a temp register
	swapf	STATUS,w		;swap the nibbles of STATUS and place into
							;the w_register, these nibbles will be swapped
							;back when the STATUS register is recovered
							;at the end of the interrupt service routine
	BANKSEL	Bank0			;forces a return to Bank 0 regardless of bank 
							;when interrupt occurred
	movwf	status_temp		;put the swapped old STATUS reg value in a temp
							;location, now with w and STATUS registers protected
							;proceed with the interrupt service
	movlw	TMR0_scale		;reload TMR0
	movwf	TMR0
	movlw	b'00100000'
	xorwf	PORTC,f			;toggle the output pin
	
	swapf	status_temp,w	;swap the nibbles in status_temp and put result in w_reg
	movwf	STATUS			;STATUS now returned to pre-interrupt value
	swapf	w_temp,f		;take the old value of w_reg and swap nibbles
	swapf	w_temp,w		;swap nibbles again and place into w_reg, w_reg
							;now returned to pre-interrupt value
	bsf		INTCON,T0IE		;enable TMR0 interrupt
	retfie					;return from interrupt this also sets GIE
	
	


;******************************************************************************
;Delay Routines
;******************************************************************************
;more delay options than needed, this is standard delay code I use in other programs
wait5sec
		call	wait1sec
		call	wait1sec
		call	wait1sec
		call	wait1sec		;1 seconds plus the one to follow
		

wait1sec
		call	wait300mS
		call	wait300mS
		call	wait300mS
		goto	wait100mS
wait300mS
        call    delay50mS
wait250mS
        call    delay50mS
        call    delay50mS
        call    delay50mS
wait100mS
        call    delay50mS
wait50mS
        call    delay50mS
		return
;delay1ms, is a very accurate 1mS delay for a 4Mhz clock.
delay1mS
        movlw   .198
        movwf   count
        nop
        goto    $+1
        goto    $+1
dly1mS        
        goto    $+1
        decfsz  count, F
        goto    dly1mS
        return
;delay5mS uses delay1mS to get a very accurate 5 mS delay
delay5mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        movlw   .4
        movwf   count
tweek5mS
        decfsz  count, F
        goto    tweek5mS
        return
;delay50mS uses delay1mS to get a very accurate 50mS delay
delay50mS
        movlw   .50
        movwf   tempa
dly50mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly50mS
        movlw   .14
        movwf   count
tweek50mS
        decfsz  count, F
        goto    tweek50mS
        return
;delay200mS uses delay1mS to get a very accurate 200mS delay.
delay200mS
        movlw   .200
        movwf   tempa
dly200mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly200mS
        movlw   .64
        movwf   count
tweek200mS
        decfsz  count, F
        goto    tweek200mS
        return

bitdelay
		movlw	.26			;delay fro 9600 baud
		movwf	count
		goto    $+1
       
bit
		decfsz	count, f
		goto	bit
		return
;end delay rountines
	end
